/*
 * File: SuchADrag.java
 * ================================================================
 * A program that shows off dragging objects around.
 */
import acm.program.*;
import acm.graphics.*;
import java.awt.*;
import java.awt.event.*;

public class SuchADrag extends GraphicsProgram {
	/* The size of the objects. */
	private static final double OBJECT_SIZE = 50;
	
	/* Sets up the world and initializes mouse listeners. */
	public void run() {
		addObjects();
		addMouseListeners();
	}
	
	/**
	 * Creates a GRect and GOval and adds them to the world
	 */
	private void addObjects() {
		/* Add a blue oval. */
		GOval oval = new GOval(0, 0, OBJECT_SIZE, OBJECT_SIZE);
		oval.setFilled(true);
		oval.setColor(Color.BLUE);
		add(oval);
		
		/* Add a blue rectangle. */
		GRect rect = new GRect(getWidth() - OBJECT_SIZE, getHeight() - OBJECT_SIZE, OBJECT_SIZE, OBJECT_SIZE);
		rect.setFilled(true);
		rect.setColor(Color.BLUE);
		add(rect);
	}
	
	/* What object is selected. */
	private GObject selected = null;
	
	/* Where the mouse last was. */
	private double lastX;
	private double lastY;
	
	/**
	 * Selects  the object under the mouse.
	 */
	public void mousePressed(MouseEvent e) {
		/* Update our selection to the object under the cursor. */
		selected = getElementAt(e.getX(), e.getY());
		
		/* If we hit something, make it red as a signal. */
		if (selected != null) {
			selected.setColor(Color.RED);
			
			/* Remember where the mouse is. */
			lastX = e.getX();
			lastY = e.getY();
		}
	}
	
	/**
	 * Deselects the object as the mouse is released.
	 */
	public void mouseReleased(MouseEvent e) {
		if (selected != null) {
			selected.setColor(Color.BLUE);
		}		
		selected = null;
	}
	
	/**
	 * Drags the selected object based on mouse movement.
	 */
	public void mouseDragged(MouseEvent e) {
		if (selected != null) {
			/* See how much the mouse has moved. */
			double dx = e.getX() - lastX;
			double dy = e.getY() - lastY;
			
			/* Update the position of the object by moving it along with the mouse. */
			selected.move(dx, dy);
			
			/* Update where the mouse was. */
			lastX = e.getX();
			lastY = e.getY();
		}
	}
}
